/*******************************************************************************
** 
** Filename: SCOFunctions.js
**
** File Description: This file contains several JavaScript functions that are 
**                   used by the Sample SCOs contained in the Sample Course.
**                   These functions encapsulate actions that are taken when the
**                   user navigates between SCOs, or exits the Lesson.
**
** Author: ADL Technical Team
**
** Contract Number:
** Company Name: CTC
**
** Design Issues:
**
** Implementation Issues:
** Known Problems:
** Side Effects:
**
** References: ADL SCORM
**
/*******************************************************************************
**
** Concurrent Technologies Corporation (CTC) grants you ("Licensee") a non-
** exclusive, royalty free, license to use, modify and redistribute this
** software in source and binary code form, provided that i) this copyright
** notice and license appear on all copies of the software; and ii) Licensee
** does not utilize the software in a manner which is disparaging to CTC.
**
** This software is provided "AS IS," without a warranty of any kind.  ALL
** EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
** IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-
** INFRINGEMENT, ARE HEREBY EXCLUDED.  CTC AND ITS LICENSORS SHALL NOT BE LIABLE
** FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
** DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL CTC  OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF CTC  HAS BEEN ADVISED OF THE
** POSSIBILITY OF SUCH DAMAGES.
**
*******************************************************************************/

/*******************************************************************************
**
** Concurrent Technologies Corporation (CTC) grants you ("Licensee") a non-
** exclusive, royalty free, license to use, modify and redistribute this
** software in source and binary code form, provided that i) this copyright
** notice and license appear on all copies of the software; and ii)Licensee does
** not utilize the software in a manner which is disparaging to CTC.
**
** This software is provided "AS IS," without a warranty of any kind.  ALL
** EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
** IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-
** INFRINGEMENT, ARE HEREBY EXCLUDED.  CTC AND ITS LICENSORS SHALL NOT BE LIABLE
** FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
** DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL CTC  OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF CTC HAS BEEN ADVISED OF THE POSSIBILITY
** OF SUCH DAMAGES.
**
*******************************************************************************/

/**
 * @license SmartBuilder4 HTML5 widget framework, Copyright (c) 2014
 *          SuddenlySmart;
 * @author Kent Xu
 */

/* Web Font Loader v1.6.28 - (c) Adobe Systems, Google. License: Apache 2.0 */

function loadPage(){var e=doLMSInitialize(),t=doLMSGetValue("cmi.core.lesson_status");"not attempted"==t&&doLMSSetValue("cmi.core.lesson_status","incomplete"),exitPageStatus=!1,startTimer()}function startTimer(){startDate=(new Date).getTime()}function computeTime(){if(0!=startDate)var e=(new Date).getTime(),t=(e-startDate)/1e3,r=convertTotalSeconds(t);else r="00:00:00.0";doLMSSetValue("cmi.core.session_time",r)}function doBack(){doLMSSetValue("cmi.core.exit","suspend"),computeTime(),exitPageStatus=!0;var e;e=doLMSCommit(),e=doLMSFinish()}function doContinue(e){doLMSSetValue("cmi.core.exit","");var t=doLMSGetValue("cmi.core.lesson_mode");"review"!=t&&"browse"!=t&&doLMSSetValue("cmi.core.lesson_status",e),computeTime(),exitPageStatus=!0;var r;r=doLMSCommit(),r=doLMSFinish()}function doQuit(e){computeTime(),exitPageStatus=!0;var t;t=doLMSCommit(),t=doLMSGetValue("cmi.core.lesson_status"),"not attempted"==t&&(t=doLMSSetValue("cmi.core.lesson_status",e)),t=doLMSCommit(),t=doLMSFinish()}function unloadPage(e){1!=exitPageStatus&&doQuit(e)}function convertTotalSeconds(e){var t=e%60;e-=t;var r=e%3600;e-=r,t=Math.round(100*t)/100;var n=new String(t),i=n,o="";if(-1!=n.indexOf(".")&&(i=n.substring(0,n.indexOf(".")),o=n.substring(n.indexOf(".")+1,n.length)),i.length<2&&(i="0"+i),n=i,o.length&&(n=n+"."+o),e%3600!=0)var a=0;else var a=e/3600;if(r%60!=0)var s=0;else var s=r/60;new String(a).length<2&&(a="0"+a),new String(s).length<2&&(s="0"+s);var c=a+":"+s+":"+n;return c}function doLMSInitialize(){var e="false";return null==api&&(api=getAPIHandle()),null!=api&&(_InternalErrorCode=API_CALL_PASSED_TO_LMS,e=api.Initialize("")),"true"!=e&&determineError(),doLMSSetValue("cmi.exit","suspend"),e}function doLMSFinish(){var e="false";return null==api&&(api=getAPIHandle()),null!=api&&(_InternalErrorCode=API_CALL_PASSED_TO_LMS,e=api.Terminate("")),"true"!=e&&determineError(),e}function doLMSGetValue(e){initializeConversionTables();var t="";if(null==api&&(api=getAPIHandle()),elementRequestArr=e.split("."),"cmi"==elementRequestArr[0]){var r=elementRequestArr.length-1;"_children"==elementRequestArr[r]?(t=childrenGetRequest(e,elementRequestArr),_InternalErrorCode=API_CALL_NOT_PASSED_TO_LMS):t=translateDataModelElement(e)}else _InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(updatedName);return t}function doLMSSetValue(e,t){initializeConversionTables(),null==api&&(api=getAPIHandle());var r="",n=e.split(".");return"cmi"==n[0]?r=dmElementSetFunction(e,t):(_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.SetValue(updatedName,t)),r}function doLMSCommit(){null==api&&(api=getAPIHandle()),_InternalErrorCode=API_CALL_PASSED_TO_LMS;var e=api.Commit("");if("true"!=e)var t=determineError();return e}function doLMSGetLastError(){var e=null;if(_InternalErrorCode==API_CALL_NOT_PASSED_TO_LMS)e=NO_ERROR;else{var t=getAPIHandle(),r=t.GetLastError().toString();e=getOldErrorValue(r)}return e}function doLMSGetErrorString(e){null==api&&(api=getAPIHandle());var t=getErrorString(e);return t}function doLMSGetDiagnostic(e){null==api&&(api=getAPIHandle());var t=getErrorString(e);return t}function determineError(){null==api&&(api=getAPIHandle());var e=doLMSGetLastError().toString();if(e!=NO_ERROR)var t=doLMSGetErrorString(e);return e}function getAPIHandle(){return null==apiHandle&&(apiHandle=getAPI()),null==apiHandle&&SB4API.handleError("Unable to locate the LMS's API Implementation."),apiHandle}function findAPI(e){for(;null==e.API_1484_11&&null!=e.parent&&e.parent!=e;){if(findAPITries++,findAPITries>500)return SB4API.handleError("Error finding API -- too deeply nested. 1.3"),null;e=e.parent}return e.API_1484_11}function getAPI(){var e=SB4API.scormAPI;return null==e&&SB4API.handleError("Unable to find an API adapter"),e}function childrenGetRequest(e,t){var r="";return"cmi.core._children"==e?r="student_id,student_name,lesson_location,credit,lesson_status,entry, score,total_time,lesson_mode,exit,session_time":"cmi.core.score._children"==e?r="raw,min,max":"cmi.student_data._children"==e?r="mastery_score,max_time_allowed,time_limit_action":"cmi.objectives._children"==e?r="id,score,status":"cmi.student_preference._children"==e?r="audio,language,speed,text":"cmi.interactions._children"==e?r="id,objectives,time,type,correct_responses,weighting,student_response,result,latency":e=="cmi.objectives."+t[2]+".score._children"&&(r="raw,min,max"),r}function translateDataModelElement(e){var t="";null==api&&(api=getAPIHandle());var r="";switch(arrayOfComponents=e.split("."),arrayOfComponents[1]){case"core":return t=convertCore(e,arrayOfComponents);case"comments":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"comments_from_lms":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"objectives":return t=convertObjectives(e,arrayOfComponents);case"student_data":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"student_preference":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"suspend_data":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"launch_data":r=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(r);break;case"interactions":return t=convertInteractions(e,arrayOfComponents);default:_InternalErrorCode=API_CALL_PASSED_TO_LMS,t=api.GetValue(e)}return t}function convertCore(e,t){var r="",n=getNewValue(e);if(null==api&&(api=getAPIHandle()),"cmi.core.lesson_status"==n){if("browsed"==statusRequest)return _InternalErrorCode=API_CALL_NOT_PASSED_TO_LMS,r="browsed";var i="not attempted",o=api.GetValue("cmi.success_status");if("passed"==o||"failed"==o)i=o;else{var a=api.GetValue("cmi.completion_status");("completed"==a||"incomplete"==a)&&(i=a)}_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=i}else _InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.GetValue(n);return r}function convertObjectives(e,t){var r="",n=getNewValue(e);return null==api&&(api=getAPIHandle()),"status"==t[3]?null==objectivesStatusRequestArr[t[2]]?(_InternalErrorCode=1,r="not attempted"):"browsed"==objectivesFlag?(_InternalErrorCode=API_CALL_NOT_PASSED_TO_LMS,r="browsed"):(_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.GetValue(objectivesStatusRequestArr[t[2]])):(n=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.GetValue(n)),r}function convertInteractions(e,t){var r="",n=getNewValue(e);if(null==api&&(api=getAPIHandle()),"time"==t[3]){InternalErrorCode=API_CALL_PASSED_TO_LMS;var i=api.GetValue("cmi.interactions."+t[2]+".timestamp");newtimeArray=i.split("T"),r=newtimeArray[1]}else"result"==t[3]?(_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.GetValue(e),"incorrect"==r&&(r="wrong")):(n=getNewValue(e),_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.GetValue(n));return r}function dmElementSetFunction(e,t){var r="";null==api&&(api=getAPIHandle());var n=getNewValue(e);switch(arrayOfComponents=e.split("."),arrayOfComponents[1]){case"core":return r=setConvertCore(e,t,arrayOfComponents);case"objectives":return r=setConvertObjectives(e,t,arrayOfComponents);case"interactions":return r=setConvertInteractions(e,t,arrayOfComponents);default:_InternalErrorCode=API_CALL_PASSED_TO_LMS,r=api.SetValue(n,t)}return r}function setConvertCore(e,t,r){var n="",i=getNewValue(e);if(null==api&&(api=getAPIHandle()),"cmi.core.lesson_status"!=e){if("cmi.core.session_time"==e){timeArray=new Array(4),timeArray=t.split(":"),hours=timeArray[0],minutes=timeArray[1],seconds=timeArray[2];var o="PT"+hours+"H"+minutes+"M"+seconds+"S";return _InternalErrorCode=API_CALL_PASSED_TO_LMS,setReturnValue=api.SetValue(i,o),n}return _InternalErrorCode=API_CALL_PASSED_TO_LMS,setReturnValue=api.SetValue(i,t),n}return"completed"==t||"incomplete"==t||"not attempted"==t?(_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue("cmi.completion_status",t),statusRequest="cmi.completion_status",n):"passed"==t||"failed"==t?(_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue("cmi.success_status",t),statusRequest="cmi.success_status",n):"browsed"==t?(_InternalErrorCode=API_CALL_NOT_PASSED_TO_LMS,n=!0,statusRequest="browsed",n):n}function setConvertObjectives(e,t,r){var n="",i=getNewValue(e);return null==api&&(api=getAPIHandle()),"status"!=r[3]?(_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue(i,t)):"passed"==t||"failed"==t?(objectivesFlag="",_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue("cmi.objectives."+r[2]+".success_status",t),objectivesStatusRequestArr[r[2]]="cmi.objectives."+r[2]+".success_status",n):"completed"==t||"incomplete"==t||"not attempted"==t?(objectivesFlag="",_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue("cmi.objectives."+r[2]+".completion_status",t),objectivesStatusRequestArr[r[2]]="cmi.objectives."+r[2]+".completion_status",n):"browsed"==t?(_InternalErrorCode=API_CALL_NOT_PASSED_TO_LMS,objectivesFlag="browsed",n=!0):n}function setConvertInteractions(e,t,r){var n="",i=getNewValue(e);if(null==api&&(api=getAPIHandle()),"latency"==r[3]){timeArray=new Array(4),timeArray=t.split(":"),hours=timeArray[0],minutes=timeArray[1],seconds=timeArray[2];var o="PT"+hours+"H"+minutes+"M"+seconds+"S";return _InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue(e,o)}if("time"==r[3]){var a=new Date,s=a.getYear(),c=a.getMonth();9>=c&&(c="0"+c);var l=a.getDay();9>=l&&(l="0"+l);var u=s+"-"+c+"-"+l+"T"+t;_InternalErrorCode=API_CALL_PASSED_TO_LMS;var f=api.SetValue("cmi.interactions."+r[2]+".timestamp",u);return f}return"result"==r[3]&&"wrong"==t?(_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue(i,"incorrect")):(_InternalErrorCode=API_CALL_PASSED_TO_LMS,n=api.SetValue(i,t));return n}function fillKeyList(){keyList[0]="cmi.core.student_id",keyList[1]="cmi.core.student_name",keyList[2]="cmi.core.lesson_location",keyList[3]="cmi.core.credit",keyList[4]="cmi.core.entry",keyList[5]="cmi.core.score.raw",keyList[6]="cmi.core.score.max",keyList[7]="cmi.core.score.min",keyList[8]="cmi.core.total_time",keyList[9]="cmi.core.lesson_mode",keyList[10]="cmi.core.exit",keyList[11]="cmi.core.session_time",keyList[12]="cmi.core.score._children",keyList[13]="cmi.student_preference._children",keyList[14]="cmi.student_preference.audio",keyList[15]="cmi.student_preference.language",keyList[16]="cmi.student_preference.speed",keyList[17]="cmi.student_preference.text",keyList[18]="cmi.student_data.mastery_score",keyList[19]="cmi.student_data.max_time_allowed",keyList[20]="cmi.student_data.time_limit_action",keyList[21]="cmi.comments_from_lms",keyList[22]="cmi.comments"}function fillValueList(){valueList[0]="cmi.learner_id",valueList[1]="cmi.learner_name",valueList[2]="cmi.location",valueList[3]="cmi.credit",valueList[4]="cmi.entry",valueList[5]="cmi.score.raw",valueList[6]="cmi.score.max",valueList[7]="cmi.score.min",valueList[8]="cmi.total_time",valueList[9]="cmi.mode",valueList[10]="cmi.exit",valueList[11]="cmi.session_time",valueList[12]="cmi.score._children",valueList[13]="cmi.learner_preference._children",valueList[14]="cmi.learner_preference.audio_level",valueList[15]="cmi.learner_preference.language",valueList[16]="cmi.learner_preference.delivery_speed",valueList[17]="cmi.learner_preference.audio_captioning",valueList[18]="cmi.scaled_passing_score",valueList[19]="cmi.max_time_allowed",valueList[20]="cmi.time_limit_action",valueList[21]="cmi.comments_from_lms.0.comment",valueList[22]="cmi.comments_from_learner.0.comment"}function getNewValue(e){var t=e,r=t.substring(0,16);if("cmi.interactions"==r){var n=t.indexOf(".",18);if(checkValue2=t.substring(n+1,n+5),"time"==checkValue2){var o=t.substring(0,n+1);t=o+"timestamp"}else if("stud"==checkValue2){var o=t.substring(0,n+1);t=o+"learner_response"}}for(i=0;i<keyList.length;i++)if(keyList[i]==e){t=valueList[i];break}return t}function fillErrorList(){errorList[0]="0",errorList[1]="101",errorList[2]="101",errorList[3]="101",errorList[4]="101",errorList[5]="101",errorList[6]="301",errorList[7]="101",errorList[8]="122",errorList[9]="101",errorList[10]="301",errorList[11]="101",errorList[12]="301",errorList[13]="143",errorList[14]="201",errorList[15]="101",errorList[16]="101",errorList[17]="101",errorList[18]="401",errorList[19]="401",errorList[20]="301",errorList[21]="403",errorList[22]="404",errorList[23]="405",errorList[24]="405",errorList[25]="405"}function fillnewErrorList(){newErrorList[0]="0",newErrorList[1]="101",newErrorList[2]="102",newErrorList[3]="103",newErrorList[4]="104",newErrorList[5]="111",newErrorList[6]="112",newErrorList[7]="113",newErrorList[8]="122",newErrorList[9]="123",newErrorList[10]="132",newErrorList[11]="133",newErrorList[12]="142",newErrorList[13]="143",newErrorList[14]="201",newErrorList[15]="301",newErrorList[16]="351",newErrorList[17]="391",newErrorList[18]="401",newErrorList[19]="402",newErrorList[20]="403",newErrorList[21]="404",newErrorList[22]="405",newErrorList[23]="406",newErrorList[24]="407",newErrorList[25]="408"}function fillErrorStringList(){errorStringList[0]="No error",errorStringList[1]="General Exception",errorStringList[2]="Invalid Augment error",errorStringList[3]="Element Cannot have Children",errorStringList[4]="Element not an array - cannot have count",errorStringList[5]="Not Initialized",errorStringList[6]="Not implemented error",errorStringList[7]="Invalid set value, element is a keyword",errorStringList[8]="Element is read only",errorStringList[9]="Element is write only",errorStringList[10]="Incorrect Data Type"}function fillErrorCodeList(){errorcodeList[0]="0",errorcodeList[1]="101",errorcodeList[2]="201",errorcodeList[3]="202",errorcodeList[4]="203",errorcodeList[5]="301",errorcodeList[6]="401",errorcodeList[7]="402",errorcodeList[8]="403",errorcodeList[9]="404",errorcodeList[10]="405"}function initializeConversionTables(){fillKeyList(),fillValueList(),fillErrorList(),fillnewErrorList(),fillErrorCodeList(),fillErrorStringList()}function getNewErrorValue(e){var t=e;for(i=0;i<errorList.length;i++)if(errorList[i]==e){t=newErrorList[i];break}return t}function getOldErrorValue(e){var t=e;for(i=0;i<newErrorList.length;i++)if(newErrorList[i]==e){t=errorList[i];break}return t}function getErrorString(e){var t=e;for(i=0;i<errorcodeList.length;i++)if(errorcodeList[i]==e){t=errorStringList[i];break}return t}var startDate,exitPageStatus;define("lib/lms/SCOFunctions.js",function(){});var NO_ERROR=0,NOT_INITIALIZED=301,API_CALL_PASSED_TO_LMS=0,API_CALL_NOT_PASSED_TO_LMS=1,apiHandle=null,api=null,findAPITries=0,_InternalErrorCode=API_CALL_PASSED_TO_LMS,hours=0,minutes=0,seconds=0,statusRequest=null,objectivesFlag="",objectivesStatusRequestArr=new Array,elementRequestArr=new Array,keyList=new Array(25),valueList=new Array(25),errorList=new Array(25),errorStringList=new Array(25),newErrorList=new Array(25),errorcodeList=new Array(25);define("lib/lms/APIWrapper.js",function(){}),define("sb4core/SCORM2004",["sb4core/DataUtil","jquery","underscore","lib/lms/SCOFunctions.js","lib/lms/APIWrapper.js"],function(e){function t(){this.scormapi=null}try{loadPage()}catch(r){}if(_.isObject(SB4API.lms)&&0!=SB4API.lms.type&&(t.prototype.getData=function(e){return this.getSCORMData(e)},t.prototype.setData=function(e,t,r){this.setSCORMData(e,t,r)},t.prototype.getSCORMData=function(e){if("undefined"!=typeof window.g_bAicc&&1==g_bAicc)return getAICCData(e);if(0==e.indexOf("cmi.objectives.n.score.raw")){var t=e.split("::");if(t.length>1){var r=this.getSCORMIDRefByIDVal("cmi.objectives","",t[1],!0),n=r.split(".");n[n.length-1]="score.raw",e=n.join(".")}}else if(0==e.indexOf("cmi.interactions.n.student_response")){var t=e.split("::");if(t.length>1){var r=this.getSCORMIDRefByIDVal("cmi.interactions","",t[1],!0),n=r.split(".");n[n.length-1]="student_response",e=n.join(".")}}if(void 0==this.scormapi)return"";var i=doLMSGetValue(e);return void 0==i&&(i=""),i},t.prototype.setSCORMData=function(e,t,r){if("undefined"!=typeof window.g_bAicc&&1==g_bAicc)return""+setAICCData(e,t);if(0==e.indexOf("cmi.objectives.n.score.raw")){var n=e.split("::");if(n.length>1){var i=this.getSCORMIDRefByIDVal("cmi.objectives","",n[1],!0),o=i.split(".");o[o.length-1]="score.raw",e=o.join(".")}}else if(0==e.indexOf("cmi.interactions.n.student_response")){var n=e.split("::");if(n.length>1){var i=this.getSCORMIDRefByIDVal("cmi.interactions","",n[1],!0),o=i.split(".");o[o.length-1]="type",e=o.join("."),doLMSSetValue(e,"fill-in");var a="",s="";_.isArray(t)&&(t.length>1&&(s=t[2]),a=t[1],t=t[0]),o[o.length-1]="result",e=o.join("."),doLMSSetValue(e,a),1==SB4API.lms.type&&null!=s&&""!=s&&(o[o.length-1]="description",e=o.join("."),doLMSSetValue(e,s)),o[o.length-1]="student_response",e=o.join(".")}}if(void 0==this.scormapi)return"true";if(0==e.indexOf("cmi.core.score.raw"))1==SB4API.lms.type?(doLMSSetValue("cmi.score.scaled",t/100),doLMSSetValue("cmi.score.max",100),doLMSSetValue("cmi.score.min",0)):2==SB4API.lms.type&&(doLMSSetValue("cmi.core.score.max",100),doLMSSetValue("cmi.core.score.min",0));else{for(var c=new Array,l=1;l<arguments.length;l++)_.isUndefined(arguments[l])||c.push(arguments[l]);t=c.join(",")}return doLMSSetValue(e,t),SB4API.lms.isCommitLMS&&doLMSCommit(),0==e.indexOf("cmi.core.score.raw")&&void 0!=r?"true":"true"},t.prototype.getSCORMArrayValue=function(e,t){for(var r=new Array,n=parseInt(doLMSGetValue(e+"._count")),i=0;n>i;i++){var o=doLMSGetValue(e+"."+i+"."+t);r.push(o)}return r},t.prototype.getSCORMIDRefByIDVal=function(e,t,r,n){var i=null,o=t+".id";""==t&&(o="id");var a;a=2==SB4API.lms.type&&0==e.indexOf("cmi.interactions")?this.getIdArray():this.getSCORMArrayValue(e,o);for(var s=0;s<a.length;s++)if(a[s]==r){i=e+"."+s+"."+o;break}return 1==n&&s>=a.length&&(i=e+"."+s+"."+o,2==SB4API.lms.type&&0==e.indexOf("cmi.interactions")&&(a.push(r),this.setIdArray(a)),doLMSSetValue(i,r)),i},t.prototype.getMasteryScore=function(){return e.parseNumber(this.getSCORMData("cmi.student_data.mastery_score"))},t.prototype.getStudentID=function(){return this.getSCORMData("cmi.core.student_id")},t.prototype.getStudentName=function(){return this.getSCORMData("cmi.core.student_name")},t.prototype.getRawScore=function(){return e.parseNumber(this.getSCORMData("cmi.core.score.raw"))},t.prototype.setRawScore=function(t){this.setSCORMData("cmi.core.score.raw",e.parseNumber(t))},t.prototype.getSCOLocation=function(){return this.getSCORMData("cmi.core.lesson_location")},t.prototype.setSCOLocation=function(e){this.setSCORMData("cmi.core.lesson_location",e)},t.prototype.getLessonStatus=function(){return this.getSCORMData("cmi.core.lesson_status")},t.prototype.setLessonStatus=function(e){this.setSCORMData("cmi.core.lesson_status",e)},t.prototype.setLessonStatusToCompleted=function(){this.setSCORMData("cmi.core.lesson_status","completed")},t.prototype.getTotalLearningTime=function(){return e.parseNumber(this.getSCORMData("cmi.core.total_time"))},t.prototype.getMaxScore=function(){return this.getSCORMData("cmi.core.score.max")},t.prototype.setMaxScore=function(t){this.setSCORMData("cmi.core.score.max",e.parseNumber(t))},t.prototype.getMinScore=function(){return this.getSCORMData("cmi.core.score.min")},t.prototype.setMinScore=function(t){this.setSCORMData("cmi.core.score.min",e.parseNumber(t))},t.prototype.lmsGetValue=function(e){return this.getSCORMData(e)},t.prototype.lmsSetValue=function(e,t){this.setSCORMData(e,t)},t.prototype.getObjectiveRawScore=function(e){return this.getSCORMData("cmi.objectives.n.score.raw::"+e)},t.prototype.setObjectiveRawScore=function(e,t){this.setSCORMData("cmi.objectives.n.score.raw::"+e,t)},t.prototype.getInteractionResponse=function(e){return 1==SB4API.lms.type?this.getSCORMData("cmi.interactions.n.student_response::"+e):""},t.prototype.setInteractionResponse=function(e,t,r){this.setSCORMData("cmi.interactions.n.student_response::"+e,[t,r])},t.prototype.setInteractionResponse2=function(e,t,r,n){this.setSCORMData("cmi.interactions.n.student_response::"+e,[t,r,n])},t.prototype.getSuspendData=function(){return this.getSCORMData("cmi.suspend_data")},t.prototype.setSuspendData=function(e){this.setSCORMData("cmi.suspend_data",e)},t.prototype.getIdArray=function(){var e=this.getSCORMData("cmi.student_preference.language");return e=null==e||""==e?[]:e.split(",")},t.prototype.setIdArray=function(e){_.isArray(e)&&this.setSCORMData("cmi.student_preference.language",e.join(","))},SB4API.SCORM2004=new t,3!=SB4API.lms.type))try{SB4API.SCORM2004.scormapi=getAPI()}catch(r){SB4API.handleError("SCORM communication disabled")}}),define("sb4core/data",[],function(){var e={};return e.lo="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",e.lodict="eJyEVtuSokgQ/RdjHyc6qOLqvAkqiNxR9nGjRBprGsHhou1MzL9vZVHY9mzEzkt3nqw0ycw6eeDnrLAq0nWzrz9naPZ15oWzLzPMjGA4L0lPGJIZSvtWIIUhs2kqAVUG7TQMBNQYXDd1L6DOYFJ0AhmQqKLHgtnzyU6Lfvbry4wepwpospPw0tBXCdbMvRTPEwXt9Vix/am0V/p+o8f+JGpj8FTQ8tSL6tqhKlpRWteTsjCb9sg9UB11EDYDL3L1NArWvraKQjlM1DR1DVEwXTnYih1tv1TXVrLT/cxKFFW3Fr4lmqA7VV9Jy22G9rKxwlhyV9vAt5ZpYIvWqOmpOlI907ScNXLdZehgM9Ey1VNYBIGIQMWaZymeZ5tZ4EZq5mPHs2PTgTYPUHt3IheYVc4buVdgszHNzqQtac1AAXnyBsxXZpKKlmCXzD4116LdsDOrqRro/cScx+ZWP/so+GhHDlVxfPZ/gweemltfvMNQ3xj859K+MrMCk/0/s/8vU001A2XbDBdmN6Kk9FoydGGoojUEfRfm3+LmWob7ltTdhbRFnd+Zq4PLZORhZg+n49OHqfuMVANkuoqwqdob50BVMfN9fMgbM+/MrJv2zIZyZhxgnh/TWCYHksRMHg70NJCHE4v8ZwINIlnAinZQHlJGmvU8Fjh3IvURbGDbpS2qhnAI1OqbsuQjQwYfMWFPBwSUGWpGUjEsRJ4KAXwQ05tGjvKpmfXTJNBRNPTJWTzl+nTwOuVYFq9kqD4Oyqdf/H428eh3P52SeazMh/ebiP7kfHtK/+mgmkYJ872K60bANbqYK2ibakheaXhh+hpOMt301bkLO4lqvtiRImPZClVDtVNpkwVSbKBUiv0thHBi+ktJs+aelxqJYikucowsVFwz3cDOIWArnSM18TzLl2R3szK2xm6v7rMQmxtYXAQsppKKTD2wdpIcbwx3v1oGerKXdomXQggQm2ZzPZXnO2eB9qm/iF1sW0YY7/2xFiA6xQ52fVnZ2AtD8qL1PrKV2MzsmGsI6kepUtx5ZBrzlZfq8sZXbE2yZbwemx5GnZH1eaRKgZZgtMSmKu08I05jriLoysuNVLxeeAbydSOVtukuDVdmsA25FCHYHpo6KHKUvY6sbGvFa2ypG3O9jZWx3PdRZIvjQ2YRbFdO6ivpPnw/Hr5JnbEk1hhIjmG5DlyKc3HhGFarGfrRe5syYVnoz7rJhy6hNUgJ5tLeMHZQLngYVi0fWiYevdmw5WFhk7Zg7b9nziM7LOKjAtjDQ/mA80+qxMPJpD8BOQMf8YFfcIQcPfQ9rGHb3rhx7NiOofgRnzuG7aSwuBg2shY/5ItYdDnYsHtvxf3GOu8Al2JS7KlsFKLlE1eTzgRGYMornVQJfxsLPzU05xiWCqSGv+hw9UCU5XsHF6xRlzM5HHPDypC8p1fa38dSYUPI5ZIVbcdGvOE+WIn+VIz1f59eqE8Daz98j9K6p7hHfUDoitTlIIKAvUNXpBD3cTdA2JfifBiVCjw3rqINUwT+M+DimYkzWQx9E1UE3hv4/tHasuje+gaEGgMf2yIvhOJ5o17LnJPkEIpvAhloSWpS3Xuad3wSMuYMOTPx7roNdNXBJ0p/Z29j8ZFyJa34GGFxLx17I/eHgVYs5Qt5b+oXtgFl0b8chr7nbJX/FAl3z//Ak/5qi9fH59D/M+2PYiP/4Xvl169/AQAA//8=",e.text="eJwszksSgjAQBNC79DoLQAyYtSfwBpEkSJESS7PgU7k7Pcj0pt9sZjb0cfm8Hr6H2fAbVg9TKHRTnL53m6xsSxhYLYFCRVRaQlyIJkiImqhDWz4dcSXCMYQmimOIhnA3CbJCHN7jeYdyZ2NNfk7/r3LeAQAA//8=",e}),define("sb4core/SB4Decode",["pako_inflate"],function(e){function t(){}return t.decodeSb4Data=function(t){var r=atob(t),n=r.split("").map(function(e){return e.charCodeAt(0)}),i=new Uint8Array(n),o=JSON.parse(e.inflate(i,{to:"string"}));return o},t.revertLoColor=function(e,t){for(var r in e)"cid"==r?(e[r]=t[e[r]],e.eClass="ColorData"):"object"==typeof e[r]&&this.revertLoColor(e[r],t)},t.revertTextWgtId=function(e,t){var r={},n=e.textReg;for(var i in n){var o=n[i];if(_.has(o,"refid")){var a=o.refid;o.refid=t[a.substring(0,a.indexOf("."))]+a.substring(a.indexOf("."))}var s=i.substring(0,i.indexOf(".")),c="";0==i.indexOf("@")&&(s=s.substring(1),c="@"),c=c+t[s]+i.substring(i.indexOf(".")),r[c]=o}e.textReg=r},t.decodeLO=function(e,t){for(var r in e)"string"==typeof e[r]&&t[r]&&t[r][e[r]]?e[r]=t[r][e[r]]:"object"==typeof e[r]&&this.decodeLO(e[r],t)
},t}),define("sb4core/loloader",["sb4core/data","sb4core/SB4Decode"],function(e,t){var r={};if("string"==typeof e.lo){var n=(new Date).getTime();r.lo=t.decodeSb4Data(e.lo),r.lodict=t.decodeSb4Data(e.lodict),r.text=t.decodeSb4Data(e.text);var i=(new Date).getTime();t.revertLoColor(r.lo,r.text.glyphReg.colorData),r.lodict.id&&t.revertTextWgtId(r.text,r.lodict.id),t.decodeLO(r.lo,r.lodict);var o=(new Date).getTime();e.lo=r.lo,e.lodict=r.lodict,e.text=r.text}else r=e,r.text||(r.text={});r.lo.lib&&(assetmap=_.clone(r.lo.lib));var a=e.lo.meta.entries;return r}),function(){function e(e,t,r){return e.call.apply(e.bind,arguments)}function t(e,t,r){if(!e)throw Error();if(2<arguments.length){var n=Array.prototype.slice.call(arguments,2);return function(){var r=Array.prototype.slice.call(arguments);return Array.prototype.unshift.apply(r,n),e.apply(t,r)}}return function(){return e.apply(t,arguments)}}function r(n,i,o){return r=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?e:t,r.apply(null,arguments)}function n(e,t){this.a=e,this.o=t||e,this.c=this.o.document}function i(e,t,r,n){if(t=e.c.createElement(t),r)for(var i in r)r.hasOwnProperty(i)&&("style"==i?t.style.cssText=r[i]:t.setAttribute(i,r[i]));return n&&t.appendChild(e.c.createTextNode(n)),t}function o(e,t,r){e=e.c.getElementsByTagName(t)[0],e||(e=document.documentElement),e.insertBefore(r,e.lastChild)}function a(e){e.parentNode&&e.parentNode.removeChild(e)}function s(e,t,r){t=t||[],r=r||[];for(var n=e.className.split(/\s+/),i=0;i<t.length;i+=1){for(var o=!1,a=0;a<n.length;a+=1)if(t[i]===n[a]){o=!0;break}o||n.push(t[i])}for(t=[],i=0;i<n.length;i+=1){for(o=!1,a=0;a<r.length;a+=1)if(n[i]===r[a]){o=!0;break}o||t.push(n[i])}e.className=t.join(" ").replace(/\s+/g," ").replace(/^\s+|\s+$/,"")}function c(e,t){for(var r=e.className.split(/\s+/),n=0,i=r.length;i>n;n++)if(r[n]==t)return!0;return!1}function l(e){return e.o.location.hostname||e.a.location.hostname}function u(e,t,r){function n(){l&&a&&s&&(l(c),l=null)}t=i(e,"link",{rel:"stylesheet",href:t,media:"all"});var a=!1,s=!0,c=null,l=r||null;tt?(t.onload=function(){a=!0,n()},t.onerror=function(){a=!0,c=Error("Stylesheet failed to load"),n()}):setTimeout(function(){a=!0,n()},0),o(e,"head",t)}function f(e,t,r,n){var o=e.c.getElementsByTagName("head")[0];if(o){var a=i(e,"script",{src:t}),s=!1;return a.onload=a.onreadystatechange=function(){s||this.readyState&&"loaded"!=this.readyState&&"complete"!=this.readyState||(s=!0,r&&r(null),a.onload=a.onreadystatechange=null,"HEAD"==a.parentNode.tagName&&o.removeChild(a))},o.appendChild(a),setTimeout(function(){s||(s=!0,r&&r(Error("Script load timeout")))},n||5e3),a}return null}function d(){this.a=0,this.c=null}function m(e){return e.a++,function(){e.a--,h(e)}}function p(e,t){e.c=t,h(e)}function h(e){0==e.a&&e.c&&(e.c(),e.c=null)}function S(e){this.a=e||"-"}function g(e,t){this.c=e,this.f=4,this.a="n";var r=(t||"n4").match(/^([nio])([1-9])$/i);r&&(this.a=r[1],this.f=parseInt(r[2],10))}function L(e){return y(e)+" "+(e.f+"00")+" 300px "+v(e.c)}function v(e){var t=[];e=e.split(/,\s*/);for(var r=0;r<e.length;r++){var n=e[r].replace(/['"]/g,"");t.push(-1!=n.indexOf(" ")||/^\d/.test(n)?"'"+n+"'":n)}return t.join(",")}function A(e){return e.a+e.f}function y(e){var t="normal";return"o"===e.a?t="oblique":"i"===e.a&&(t="italic"),t}function w(e){var t=4,r="n",n=null;return e&&((n=e.match(/(normal|oblique|italic)/i))&&n[1]&&(r=n[1].substr(0,1).toLowerCase()),(n=e.match(/([1-9]00|normal|bold)/i))&&n[1]&&(/bold/i.test(n[1])?t=7:/[1-9]00/.test(n[1])&&(t=parseInt(n[1].substr(0,1),10)))),r+t}function I(e,t){this.c=e,this.f=e.o.document.documentElement,this.h=t,this.a=new S("-"),this.j=!1!==t.events,this.g=!1!==t.classes}function _(e){e.g&&s(e.f,[e.a.c("wf","loading")]),O(e,"loading")}function b(e){if(e.g){var t=c(e.f,e.a.c("wf","active")),r=[],n=[e.a.c("wf","loading")];t||r.push(e.a.c("wf","inactive")),s(e.f,r,n)}O(e,"inactive")}function O(e,t,r){e.j&&e.h[t]&&(r?e.h[t](r.c,A(r)):e.h[t]())}function P(){this.c={}}function C(e,t,r){var n=[],i;for(i in t)if(t.hasOwnProperty(i)){var o=e.c[i];o&&n.push(o(t[i],r))}return n}function E(e,t){this.c=e,this.f=t,this.a=i(this.c,"span",{"aria-hidden":"true"},this.f)}function M(e){o(e.c,"body",e.a)}function D(e){return"display:block;position:absolute;top:-9999px;left:-9999px;font-size:300px;width:auto;height:auto;line-height:normal;margin:0;padding:0;font-variant:normal;white-space:nowrap;font-family:"+v(e.c)+";"+("font-style:"+y(e)+";font-weight:"+(e.f+"00")+";")}function x(e,t,r,n,i,o){this.g=e,this.j=t,this.a=n,this.c=r,this.f=i||3e3,this.h=o||void 0}function T(e,t,r,n,i,o,a){this.v=e,this.B=t,this.c=r,this.a=n,this.s=a||"BESbswy",this.f={},this.w=i||3e3,this.u=o||null,this.m=this.j=this.h=this.g=null,this.g=new E(this.c,this.s),this.h=new E(this.c,this.s),this.j=new E(this.c,this.s),this.m=new E(this.c,this.s),e=new g(this.a.c+",serif",A(this.a)),e=D(e),this.g.a.style.cssText=e,e=new g(this.a.c+",sans-serif",A(this.a)),e=D(e),this.h.a.style.cssText=e,e=new g("serif",A(this.a)),e=D(e),this.j.a.style.cssText=e,e=new g("sans-serif",A(this.a)),e=D(e),this.m.a.style.cssText=e,M(this.g),M(this.h),M(this.j),M(this.m)}function R(){if(null===nt){var e=/AppleWebKit\/([0-9]+)(?:\.([0-9]+))/.exec(window.navigator.userAgent);nt=!!e&&(536>parseInt(e[1],10)||536===parseInt(e[1],10)&&11>=parseInt(e[2],10))}return nt}function j(e,t,r){for(var n in rt)if(rt.hasOwnProperty(n)&&t===e.f[rt[n]]&&r===e.f[rt[n]])return!0;return!1}function k(e){var t=e.g.a.offsetWidth,r=e.h.a.offsetWidth,n;(n=t===e.f.serif&&r===e.f["sans-serif"])||(n=R()&&j(e,t,r)),n?et()-e.A>=e.w?R()&&j(e,t,r)&&(null===e.u||e.u.hasOwnProperty(e.a.c))?B(e,e.v):B(e,e.B):V(e):B(e,e.v)}function V(e){setTimeout(r(function(){k(this)},e),50)}function B(e,t){setTimeout(r(function(){a(this.g.a),a(this.h.a),a(this.j.a),a(this.m.a),t(this.a)},e),0)}function q(e,t,r){this.c=e,this.a=t,this.f=0,this.m=this.j=!1,this.s=r}function N(e){0==--e.f&&e.j&&(e.m?(e=e.a,e.g&&s(e.f,[e.a.c("wf","active")],[e.a.c("wf","loading"),e.a.c("wf","inactive")]),O(e,"active")):b(e.a))}function F(e){this.j=e,this.a=new P,this.h=0,this.f=this.g=!0}function G(e,t,n,i,o){var a=0==--e.h;(e.f||e.g)&&setTimeout(function(){var e=o||null,c=i||null||{};if(0===n.length&&a)b(t.a);else{t.f+=n.length,a&&(t.j=a);var l,u=[];for(l=0;l<n.length;l++){var f=n[l],d=c[f.c],m=t.a,p=f;if(m.g&&s(m.f,[m.a.c("wf",p.c,A(p).toString(),"loading")]),O(m,"fontloading",p),m=null,null===it)if(window.FontFace){var p=/Gecko.*Firefox\/(\d+)/.exec(window.navigator.userAgent),h=/OS X.*Version\/10\..*Safari/.exec(window.navigator.userAgent)&&/Apple/.exec(window.navigator.vendor);it=p?42<parseInt(p[1],10):h?!1:!0}else it=!1;m=it?new x(r(t.g,t),r(t.h,t),t.c,f,t.s,d):new T(r(t.g,t),r(t.h,t),t.c,f,t.s,e,d),u.push(m)}for(l=0;l<u.length;l++)u[l].start()}},0)}function H(e,t,r){var n=[],i=r.timeout;_(t);var n=C(e.a,r,e.c),o=new q(e.c,t,i);for(e.h=n.length,t=0,r=n.length;r>t;t++)n[t].load(function(t,r,n){G(e,o,t,r,n)})}function Y(e,t){this.c=e,this.a=t}function K(e,t){this.c=e,this.a=t}function X(e,t){this.c=e?e:ot,this.a=[],this.f=[],this.g=t||""}function W(e,t){for(var r=t.length,n=0;r>n;n++){var i=t[n].split(":");3==i.length&&e.f.push(i.pop());var o="";2==i.length&&""!=i[1]&&(o=":"),e.a.push(i.join(o))}}function U(e){if(0==e.a.length)throw Error("No fonts to load!");if(-1!=e.c.indexOf("kit="))return e.c;for(var t=e.a.length,r=[],n=0;t>n;n++)r.push(e.a[n].replace(/ /g,"+"));return t=e.c+"?family="+r.join("%7C"),0<e.f.length&&(t+="&subset="+e.f.join(",")),0<e.g.length&&(t+="&text="+encodeURIComponent(e.g)),t}function J(e){this.f=e,this.a=[],this.c={}}function Q(e){for(var t=e.f.length,r=0;t>r;r++){var n=e.f[r].split(":"),i=n[0].replace(/\+/g," "),o=["n4"];if(2<=n.length){var a,s=n[1];if(a=[],s)for(var s=s.split(","),c=s.length,l=0;c>l;l++){var u;if(u=s[l],u.match(/^[\w-]+$/)){var f=lt.exec(u.toLowerCase());if(null==f)u="";else{if(u=f[2],u=null==u||""==u?"n":ct[u],f=f[1],null==f||""==f)f="4";else var d=st[f],f=d?d:isNaN(f)?"4":f.substr(0,1);u=[u,f].join("")}}else u="";u&&a.push(u)}0<a.length&&(o=a),3==n.length&&(n=n[2],a=[],n=n?n.split(","):a,0<n.length&&(n=at[n[0]])&&(e.c[i]=n))}for(e.c[i]||(n=at[i])&&(e.c[i]=n),n=0;n<o.length;n+=1)e.a.push(new g(i,o[n]))}}function z(e,t){this.c=e,this.a=t}function Z(e,t){this.c=e,this.a=t}function $(e,t){this.c=e,this.f=t,this.a=[]}var et=Date.now||function(){return+new Date},tt=!!window.FontFace;S.prototype.c=function(e){for(var t=[],r=0;r<arguments.length;r++)t.push(arguments[r].replace(/[\W_]+/g,"").toLowerCase());return t.join(this.a)},x.prototype.start=function(){var e=this.c.o.document,t=this,r=et(),n=new Promise(function(n,i){function o(){et()-r>=t.f?i():e.fonts.load(L(t.a),t.h).then(function(e){1<=e.length?n():setTimeout(o,25)},function(){i()})}o()}),i=null,o=new Promise(function(e,r){i=setTimeout(r,t.f)});Promise.race([o,n]).then(function(){i&&(clearTimeout(i),i=null),t.g(t.a)},function(){t.j(t.a)})};var rt={D:"serif",C:"sans-serif"},nt=null;T.prototype.start=function(){this.f.serif=this.j.a.offsetWidth,this.f["sans-serif"]=this.m.a.offsetWidth,this.A=et(),k(this)};var it=null;q.prototype.g=function(e){var t=this.a;t.g&&s(t.f,[t.a.c("wf",e.c,A(e).toString(),"active")],[t.a.c("wf",e.c,A(e).toString(),"loading"),t.a.c("wf",e.c,A(e).toString(),"inactive")]),O(t,"fontactive",e),this.m=!0,N(this)},q.prototype.h=function(e){var t=this.a;if(t.g){var r=c(t.f,t.a.c("wf",e.c,A(e).toString(),"active")),n=[],i=[t.a.c("wf",e.c,A(e).toString(),"loading")];r||n.push(t.a.c("wf",e.c,A(e).toString(),"inactive")),s(t.f,n,i)}O(t,"fontinactive",e),N(this)},F.prototype.load=function(e){this.c=new n(this.j,e.context||this.j),this.g=!1!==e.events,this.f=!1!==e.classes,H(this,new I(this.c,e),e)},Y.prototype.load=function(e){function t(){if(o["__mti_fntLst"+n]){var r=o["__mti_fntLst"+n](),i=[],a;if(r)for(var s=0;s<r.length;s++){var c=r[s].fontfamily;void 0!=r[s].fontStyle&&void 0!=r[s].fontWeight?(a=r[s].fontStyle+r[s].fontWeight,i.push(new g(c,a))):i.push(new g(c))}e(i)}else setTimeout(function(){t()},50)}var r=this,n=r.a.projectId,i=r.a.version;if(n){var o=r.c.o;f(this.c,(r.a.api||"https://fast.fonts.net/jsapi")+"/"+n+".js"+(i?"?v="+i:""),function(i){i?e([]):(o["__MonotypeConfiguration__"+n]=function(){return r.a},t())}).id="__MonotypeAPIScript__"+n}else e([])},K.prototype.load=function(e){var t,r,n=this.a.urls||[],i=this.a.families||[],o=this.a.testStrings||{},a=new d;for(t=0,r=n.length;r>t;t++)u(this.c,n[t],m(a));var s=[];for(t=0,r=i.length;r>t;t++)if(n=i[t].split(":"),n[1])for(var c=n[1].split(","),l=0;l<c.length;l+=1)s.push(new g(n[0],c[l]));else s.push(new g(n[0]));p(a,function(){e(s,o)})};var ot="https://fonts.googleapis.com/css",at={latin:"BESbswy","latin-ext":"çöüğş",cyrillic:"йяЖ",greek:"αβΣ",khmer:"កខគ",Hanuman:"កខគ"},st={thin:"1",extralight:"2","extra-light":"2",ultralight:"2","ultra-light":"2",light:"3",regular:"4",book:"4",medium:"5","semi-bold":"6",semibold:"6","demi-bold":"6",demibold:"6",bold:"7","extra-bold":"8",extrabold:"8","ultra-bold":"8",ultrabold:"8",black:"9",heavy:"9",l:"3",r:"4",b:"7"},ct={i:"i",italic:"i",n:"n",normal:"n"},lt=/^(thin|(?:(?:extra|ultra)-?)?light|regular|book|medium|(?:(?:semi|demi|extra|ultra)-?)?bold|black|heavy|l|r|b|[1-9]00)?(n|i|normal|italic)?$/,ut={Arimo:!0,Cousine:!0,Tinos:!0};z.prototype.load=function(e){var t=new d,r=this.c,n=new X(this.a.api,this.a.text),i=this.a.families;W(n,i);var o=new J(i);Q(o),u(r,U(n),m(t)),p(t,function(){e(o.a,o.c,ut)})},Z.prototype.load=function(e){var t=this.a.id,r=this.c.o;t?f(this.c,(this.a.api||"https://use.typekit.net")+"/"+t+".js",function(t){if(t)e([]);else if(r.Typekit&&r.Typekit.config&&r.Typekit.config.fn){t=r.Typekit.config.fn;for(var n=[],i=0;i<t.length;i+=2)for(var o=t[i],a=t[i+1],s=0;s<a.length;s++)n.push(new g(o,a[s]));try{r.Typekit.load({events:!1,classes:!1,async:!0})}catch(c){}e(n)}},2e3):e([])},$.prototype.load=function(e){var t=this.f.id,r=this.c.o,n=this;t?(r.__webfontfontdeckmodule__||(r.__webfontfontdeckmodule__={}),r.__webfontfontdeckmodule__[t]=function(t,r){for(var i=0,o=r.fonts.length;o>i;++i){var a=r.fonts[i];n.a.push(new g(a.name,w("font-weight:"+a.weight+";font-style:"+a.style)))}e(n.a)},f(this.c,(this.f.api||"https://f.fontdeck.com/s/css/js/")+l(this.c)+"/"+t+".js",function(t){t&&e([])})):e([])};var ft=new F(window);ft.a.c.custom=function(e,t){return new K(t,e)},ft.a.c.fontdeck=function(e,t){return new $(t,e)},ft.a.c.monotype=function(e,t){return new Y(t,e)},ft.a.c.typekit=function(e,t){return new Z(t,e)},ft.a.c.google=function(e,t){return new z(t,e)};var dt={load:r(ft.load,ft)};"function"==typeof define&&define.amd?define("sb4core/webfontloader",[],function(){return dt}):"undefined"!=typeof module&&module.exports?module.exports=dt:(window.WebFont=dt,window.WebFontConfig&&ft.load(window.WebFontConfig))}(),define("sb4core/fontloader",["sb4core/webfontloader"],function(e){var t=$.Deferred();return e.load({custom:{families:["Roboto:n4,n7,i4,i7"],urls:["fonts/fonts.css"]},active:function(){t.resolve()},inactive:function(){t.resolve()},timeout:1e6}),t}),define("wgt/com.smartbuilder.axon.widget.data.track/s",["sb4core/DataUtil","module","sb4core/sbobj"],function(e,t,r){var n=t.config(),i=n.widgetsvc,o=i.getShortUIKey();return $.widget(i.getFullUIKey(),$.sb4[r],{options:{},_create:function(){var e=this.options;this.element.addClass(o),this._super(),this.element.css({display:"none"})},_init:function(){var e=this,t=this.options;this.lmsEnable=!1},_onStageReady:function(){this._super(),this.fireEvent("onLoad",void 0,void 0,!0)},_destroy:function(){this._super()},setBookmark:function(e){this.lmsEnable&&SB4API.SCORM2004.setSCOLocation(e)},getBookmark:function(){return this.lmsEnable?SB4API.SCORM2004.getSCOLocation():void 0},setStatus:function(e){this.lmsEnable&&SB4API.SCORM2004.setLessonStatus(e)},getStatus:function(){return this.lmsEnable?SB4API.SCORM2004.getLessonStatus():void 0},setScore:function(e){this.lmsEnable&&SB4API.SCORM2004.setRawScore(e)},getScore:function(){return this.lmsEnable?SB4API.SCORM2004.getRawScore():void 0},setMaxScore:function(e){this.lmsEnable&&SB4API.SCORM2004.setMaxScore(e)},getMaxScore:function(){return this.lmsEnable?SB4API.SCORM2004.getMaxScore():void 0},setMinScore:function(e){this.lmsEnable&&SB4API.SCORM2004.setMinScore(e)},getMinScore:function(){return this.lmsEnable?SB4API.SCORM2004.getMinScore():void 0},setObjectiveScore:function(e,t){this.lmsEnable&&SB4API.SCORM2004.setObjectiveRawScore(e,t)},getObjectiveScore:function(e){return this.lmsEnable?SB4API.SCORM2004.getObjectiveRawScore(e):void 0},setInteraction:function(e,t,r){return this.lmsEnable?SB4API.SCORM2004.setInteractionResponse(e,t,r):void 0},setInteraction2:function(e,t,r,n){return this.lmsEnable?SB4API.SCORM2004.setInteractionResponse2(e,t,r,n):void 0},getInteraction:function(e){return this.lmsEnable?SB4API.SCORM2004.getInteractionResponse(e):void 0},setValue:function(e,t){this.lmsEnable&&SB4API.SCORM2004.setData(e,t)},getValue:function(e){return this.lmsEnable?SB4API.SCORM2004.getData(e):void 0},setSuspendData:function(e){this.lmsEnable&&SB4API.SCORM2004.setSuspendData(e)},getSuspendData:function(){return this.lmsEnable?SB4API.SCORM2004.getSuspendData():void 0},makeAjaxCall:function(e,t){var r="GET";_.isArray(params)&&!_.isEmpty(params)&&(r="POST"),$.ajax({url:e,data:self.arrayToObject(params),crossDomain:!0,type:r}).done(function(e){}).fail(function(){})},makeSyncAjaxCall:function(e,t){var r="GET";_.isArray(params)&&!_.isEmpty(params)&&(r="POST");var n=$.Deferred();return $.ajax({url:e,crossDomain:!0,data:self.arrayToObject(params),type:r}).done(function(e){n.resolve(e)}).fail(function(){n.resolve()}),n},getMasteryScore:function(){return this.lmsEnable?SB4API.SCORM2004.getMasteryScore():void 0},getLearnerName:function(){return this.lmsEnable?SB4API.SCORM2004.getStudentName():void 0},getLearnerID:function(){return this.lmsEnable?SB4API.SCORM2004.getStudentID():void 0},terminate:function(){this.lmsEnable&&(unloadPage("incomplete"),this.lmsEnable=!1)}}),i.getShortUIKey()}),define("sb4core/parse/ext/local_declaration_statement",["sb4core/SB4ParseCore"],function(e){e.prototype.parseLocalDeclarationStatement=function(e,t){var r=this,n=t.then(function(){r.logger._info(e.attr("id")+"."+e.attr("type")+" start ... ");var t=e.children("field");if(t.length>0){var n=$.Deferred(),i=0;r.engine.objctx=r.engine.objctx.fork(),$.each(t,function(t,o){var a=$(o).html(),s=$.Deferred();r.parseBlock(e.children("value[name=DECL"+t+"]").find("block:first"),s).then(function(t){r.engine.objctx.add(a,t),i+=1,i==e.children("value").length&&n.resolve()}),s.resolve()});var o=n.then(function(){var t=$.Deferred(),n=r.parseBlock(e.children("statement[name=STACK]").find("block:first"),t);return t.resolve(),n}).then(function(){r.engine.objctx=r.engine.objctx.pop()});return o}});return n}}),define("sb4core/parse/ext/math_random_int",["sb4core/SB4ParseCore","sb4core/DataUtil"],function(e,t){e.prototype.parseMathRandomInt=function(e,r){var n=this,i=r.then(function(){n.logger._info(e.attr("id")+"."+e.attr("type")+" start ... ");var r=$.Deferred(),i=$.Deferred(),o=n.parseBlock(e.children("value[name=FROM]").find("block:first"),r),a=n.parseBlock(e.children("value[name=TO]").find("block:first"),i);r.resolve(),i.resolve();var s=$.when(o,a).then(function(r,i){n.logger._debug(e.attr("id")+"."+e.attr("type")+" "+r+" : "+i);var o=t.parseNumber(r),a=t.parseNumber(i);return a>o?parseInt(Math.random()*(a-o+1)+o):o>a?parseInt(Math.random()*(o-a+1)+a):o});return s});return i}}),define("sb4core/init-wgt",["sb4core/fontloader","wgt/com.smartbuilder.axon.widget.data.track/s","sb4core/parse/ext/local_declaration_statement","sb4core/parse/ext/math_random_int"],function(){SB4API.stageLog("SB4 widgets loader finished");var e=Array.prototype.slice.call(arguments),t=$.when.apply($,e).then(function(){});return t}),define("axon",["sb4core/SCORM2004","sb4core/loloader"],function(){$(function(){require(["sb4core/init-post"],function(e){require(["sb4core/init-wgt"],function(t){t.always(function(){require(["sb4core/SB4ConfigLoader"],function(t){function r(){if(null!=SB4API.xapi.initLaunch)if(1==SB4API.xapi.initLaunch)e.play();else var t=setInterval(function(){1==SB4API.xapi.initLaunch?(clearInterval(t),e.play()):2==SB4API.xapi.initLaunch&&clearInterval(t)},1e3);else e.play();"function"==typeof OnJavaLoadLessonFunction&&OnJavaLoadLessonFunction(),null!=SB4API&&"function"==typeof SB4API.onLoadLesson&&SB4API.onLoadLesson(),$("#player-msgbox").remove()}var n=$.when.apply($,arguments).then(function(){r()})})})})})})},function(e){var t=e.requireModules&&e.requireModules[0];"jquery"===t&&(requirejs.undef(t),requirejs.config({paths:{jquery:"local/jquery"}}),require(["jquery"],function(){}))}),define("text!widgets/com.smartbuilder.axon.widget.shape/styles.xml",[],function(){return'<svg focusable="false" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="0" height="0"><defs></defs></svg>'}),define("text!widgets/com.smartbuilder.axon.widget.button/styles.xml",[],function(){return'<svg focusable="false" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="0" height="0" id="buttoneffect"><defs><filter width="200%" height="200%" id="buttondarksvg"><feComponentTransfer in="SourceGraphic" result="offOut"><feFuncA type="linear" slope="1.2" /><feFuncR type="linear" slope="1.2" /><feFuncG type="linear" slope="1.2" /><feFuncB type="linear" slope="1.2" /></feComponentTransfer></filter><filter width="200%" height="200%" id="buttonlightsvg"><feComponentTransfer in="SourceGraphic" result="offOut"><feFuncA type="linear" slope="0.8" /><feFuncR type="linear" slope="1" /><feFuncG type="linear" slope="1" /><feFuncB type="linear" slope="1" /></feComponentTransfer></filter><filter width="200%" height="200%" id="buttongarysvg"><feColorMatrix type="matrix" values="0.35 0.35 0.35 0 0 0.35 0.35 0.35 0 0 0.35 0.35 0.35 0 0 0 0 0 1 0"/></filter></defs></svg>'});